<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\OnlinePurchaseRequest;
use App\Models\Shipment;
use App\Models\Trip;
use App\Models\TripCompanion; // ✅ اضافه شد
use Illuminate\Http\Response;

class AdminAllRequestsController extends Controller
{
    public function index()
    {
        $admin = auth()->user();
        if (!$admin instanceof Admin) {
            return response()->json(['error' => 'Unauthorized'], Response::HTTP_FORBIDDEN);
        }

        $allRequests = collect();

        // 1. درخواست‌های حمل‌ونقل (ارسال/حمل)
        Shipment::with('user')->get()->each(function ($s) use (&$allRequests) {
            $allRequests->push([
                'id' => 'SHIP-' . $s->id,
                'type' => 'shipment',
                'request_id' => $s->id, // ✅ شناسه عددی
                'title' => $s->title ?? 'درخواست مرسوله',
                'user' => [
                    'name' => $s->user?->name ?? 'نامشخص',
                    'avatar' => $s->user?->name 
                        ? 'https://ui-avatars.com/api/?name=' . urlencode($s->user->name) . '&background=random'
                        : 'https://ui-avatars.com/api/?name=نامشخص&background=gray'
                ],
                'origin_country' => $s->origin_country ?? 'نامشخص',
                'destination_country' => $s->destination_country ?? 'نامشخص',
                'status' => $s->status, // ✅ وضعیت اصلی
                'datePosted' => $s->created_at ? $s->created_at->diffForHumans() : 'نامشخص',
                'created_at' => $s->created_at,
            ]);
        });

        // 2. درخواست‌های سفر
        Trip::with('user')->get()->each(function ($t) use (&$allRequests) {
            $allRequests->push([
                'id' => 'TRIP-' . $t->id,
                'type' => 'trip',
                'request_id' => $t->id, // ✅ شناسه عددی
                'title' => $t->description ?? 'درخواست سفر',
                'user' => [
                    'name' => $t->user?->name ?? 'نامشخص',
                    'avatar' => $t->user?->name 
                        ? 'https://ui-avatars.com/api/?name=' . urlencode($t->user->name) . '&background=random'
                        : 'https://ui-avatars.com/api/?name=نامشخص&background=gray'
                ],
                'origin_country' => $t->origin_country ?? 'نامشخص',
                'destination_country' => $t->destination_country ?? 'نامشخص',
                'status' => $t->status, // ✅ وضعیت اصلی
                'datePosted' => $t->created_at ? $t->created_at->diffForHumans() : 'نامشخص',
                'created_at' => $t->created_at,
            ]);
        });

        // 3. درخواست‌های همسفری
        TripCompanion::with('user')->get()->each(function ($tc) use (&$allRequests) {
            $allRequests->push([
                'id' => 'COMP-' . $tc->id,
                'type' => 'trip',
                'request_id' => $tc->id, // ✅ شناسه عددی
                'title' => $tc->description ?? 'درخواست همسفری',
                'user' => [
                    'name' => $tc->user?->name ?? 'نامشخص',
                    'avatar' => $tc->user?->name 
                        ? 'https://ui-avatars.com/api/?name=' . urlencode($tc->user->name) . '&background=random'
                        : 'https://ui-avatars.com/api/?name=نامشخص&background=gray'
                ],
                'origin_country' => $tc->origin_country ?? 'نامشخص',
                'destination_country' => $tc->destination_country ?? 'نامشخص',
                'status' => $tc->status, // ✅ وضعیت اصلی
                'datePosted' => $tc->created_at ? $tc->created_at->diffForHumans() : 'نامشخص',
                'created_at' => $tc->created_at,
            ]);
        });

        // 4. درخواست‌های خرید
        OnlinePurchaseRequest::with('user')->get()->each(function ($p) use (&$allRequests) {
            $allRequests->push([
                'id' => 'PURC-' . $p->id,
                'type' => 'purchase',
                'request_id' => $p->id, // ✅ شناسه عددی
                'title' => $p->title ?? 'درخواست خرید',
                'user' => [
                    'name' => $p->user?->name ?? 'نامشخص',
                    'avatar' => $p->user?->name 
                        ? 'https://ui-avatars.com/api/?name=' . urlencode($p->user->name) . '&background=random'
                        : 'https://ui-avatars.com/api/?name=نامشخص&background=gray'
                ],
                'origin_country' => 'اینترنت',
                'destination_country' => $p->delivery_country ?? 'نامشخص',
                'status' => $p->status, // ✅ وضعیت اصلی
                'datePosted' => $p->created_at ? $p->created_at->diffForHumans() : 'نامشخص',
                'created_at' => $p->created_at,
            ]);
        });

        // مرتب‌سازی بر اساس تاریخ (جدیدترین اول)
        $allRequests = $allRequests->sortByDesc('created_at')->values();

        return response()->json($allRequests);
    }
}