<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class AdminUserController extends Controller
{
    public function index(Request $request)
    {
        $admin = auth()->user();
        if (!$admin instanceof Admin) {
            return response()->json(['error' => 'Unauthorized'], Response::HTTP_FORBIDDEN);
        }

        $query = User::query();

        // فیلتر بر اساس وضعیت
        if ($status = $request->get('status')) {
            if ($status !== 'all') {
                $query->where('status', $status);
            }
        }

        // جستجو در نام و شماره
        if ($search = $request->get('search')) {
            $query->where(function ($q) use ($search) {
                $q->where('name', 'like', "%{$search}%")
                  ->orWhere('phone', 'like', "%{$search}%");
            });
        }

        $perPage = (int) ($request->get('per_page') ?? 15);
        $page = (int) ($request->get('page') ?? 1);

        $users = $query->paginate($perPage, ['*'], 'page', $page);

        return response()->json([
            'data' => $users->items(),
            'meta' => [
                'current_page' => $users->currentPage(),
                'last_page' => $users->lastPage(),
                'per_page' => $users->perPage(),
                'total' => $users->total(),
            ]
        ]);
    }

    public function ban(string $id)
    {
        $admin = auth()->user();
        if (!$admin instanceof Admin) {
            return response()->json(['error' => 'Unauthorized'], Response::HTTP_FORBIDDEN);
        }

        $user = User::find($id);
        if (!$user) {
            return response()->json(['error' => 'کاربر یافت نشد'], Response::HTTP_NOT_FOUND);
        }

        $user->update(['status' => 'banned']);
        return response()->json(['message' => 'کاربر با موفقیت مسدود شد']);
    }

    public function unban(string $id)
    {
        $admin = auth()->user();
        if (!$admin instanceof Admin) {
            return response()->json(['error' => 'Unauthorized'], Response::HTTP_FORBIDDEN);
        }

        $user = User::find($id);
        if (!$user) {
            return response()->json(['error' => 'کاربر یافت نشد'], Response::HTTP_NOT_FOUND);
        }

        $user->update(['status' => 'active']);
        return response()->json(['message' => 'کاربر با موفقیت فعال شد']);
    }
}