<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class AdminAuthController extends Controller
{
    public function requestOtp(Request $request)
    {
        $request->validate([
            'phone' => 'required|string|regex:/^09[0-9]{9}$/'
        ]);

        $phone = $request->phone;

        // دیباگ
        \Log::info("Searching for admin with phone: {$phone}");
        $admin = Admin::where('phone', $phone)->first();
        \Log::info("Admin found: " . ($admin ? 'YES' : 'NO'));

        if (!$admin) {
            return response()->json([
                'error' => 'شماره تلفن شما در سیستم ثبت نشده است.'
            ], 403);
        }

        // محدودیت: حداکثر 6 درخواست در 1 ساعت
        $hourlyKey = "admin_otp_hourly_limit:{$phone}";
        $attempts = Cache::get($hourlyKey, 0);
        if ($attempts >= 6) {
            return response()->json([
                'error' => 'شما بیش از 6 بار در یک ساعت درخواست داده‌اید. لطفاً بعداً تلاش کنید.'
            ], 429);
        }

        // اگر کد هنوز معتبر است
        $otpKey = "admin_otp:{$phone}";
        if (Cache::has($otpKey)) {
            return response()->json([
                'message' => 'کد قبلاً ارسال شده است.'
            ], 200);
        }

        // تولید OTP جدید
        $otp = 111111; // rand(100000, 999999);

        // ذخیره OTP (10 دقیقه)
        Cache::put($otpKey, $otp, 600);

        // افزایش شمارنده
        Cache::put($hourlyKey, $attempts + 1, 3600);

        \Log::info("Admin OTP for {$phone}: {$otp}");

        return response()->json([
            'message' => 'کد تأیید با موفقیت ارسال شد.'
        ]);
    }

    public function verifyOtp(Request $request)
    {
        $request->validate([
            'phone' => 'required|string|regex:/^09[0-9]{9}$/',
            'otp'   => 'required|digits:6'
        ]);

        $phone = $request->phone;
        $otp = $request->otp;

        $storedOtp = Cache::get("admin_otp:{$phone}");

        if (!$storedOtp || $storedOtp != $otp) {
            return response()->json([
                'error' => 'کد نامعتبر یا منقضی شده است.'
            ], 400);
        }

        // پیدا کردن ادمین (باید از قبل وجود داشته باشد)
        $admin = Admin::where('phone', $phone)->first();

        if (!$admin) {
            return response()->json([
                'error' => 'دسترسی غیرمجاز.'
            ], 403);
        }

        // بروزرسانی زمان تأیید
        $admin->update(['phone_verified_at' => now()]);

        // صدور توکن با نام متفاوت
        $token = $admin->createToken('eino-admin-token')->plainTextToken;

        // پاک کردن OTP
        Cache::forget("admin_otp:{$phone}");

        return response()->json([
            'message' => 'ورود موفقیت‌آمیز بود.',
            'token' => $token,
            'admin' => $admin
        ]);
    }
}
