<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class UserIndexRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'page' => 'nullable|integer|min=1',
            'per_page' => 'nullable|integer|between:1,100',
            'search' => 'nullable|string|max:255',
            'status' => 'nullable|in:all,active,banned',
        ];
    }

    public function getPage(): int
    {
        return (int) $this->get('page', 1);
    }

    public function getPerPage(): int
    {
        return (int) $this->get('per_page', 15);
    }

    public function getSearch(): ?string
    {
        return $this->get('search');
    }

    public function getStatus(): ?string
    {
        return $this->get('status') !== 'all' ? $this->get('status') : null;
    }
}