<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OnlinePurchaseImage extends Model
{
    // نام جدول رو مشخص می‌کنیم (اسم دقیق از migration)
    protected $table = 'online_purchase_images';

    // فیلدهایی که قابل پر شدن هستن
    protected $fillable = [
        'purchase_request_id',
        'path',
    ];

    // غیرفعال کردن timestamps اگه توی جدول نداری
    // public $timestamps = false;

    // رابطه با درخواست خرید
    public function purchase(): BelongsTo
    {
        return $this->belongsTo(OnlinePurchaseRequest::class, 'purchase_id');
    }
}
