<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class OnlinePurchaseRequest extends Model
{
    
    protected $fillable = [
        'user_id',
        'title',
        'link',
        'description',
        'purchase_country',
        'purchase_city',
        'delivery_country',
        'delivery_city',
        'delivery_address',
        'delivery_lat',
        'delivery_lng',
        'item_price',
        'proposed_fee',
        'currency',
        'show_phone',
        'status',
        'rejection_reason',
    ];

    protected $casts = [
        'item_price' => 'decimal:2',
        'proposed_fee' => 'decimal:2',
        'delivery_lat' => 'decimal:8',
        'delivery_lng' => 'decimal:8',
        'show_phone' => 'boolean',
    ];

    // رابطه با کاربر
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    // رابطه با تصاویر (این خط مهمه!)
    public function images(): HasMany
    {
        return $this->hasMany(OnlinePurchaseImage::class, 'purchase_request_id');
    }
}
