<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class OnlinePurchaseShopper extends Model
{
    protected $fillable = [
        'user_id',
        'service_title',
        'categories',
        'supported_sites',
        'fee_description',
        'capabilities',
        'country',
        'city',
        'status',
        'rejection_reason',
    ];

    // این خط مهمه! لاراول باید بدونه categories و supported_sites آرایه هستن
    protected $casts = [
        'categories' => 'array',
        'supported_sites' => 'array',
    ];

    // رابطه با کاربر
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    // رابطه با تصاویر (این خط مهمه!)
    public function images(): HasMany
    {
        return $this->hasMany(OnlinePurchaseShopperImage::class, 'purchase_shopper_id');
    }
}
