<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OnlinePurchaseShopperImage extends Model
{
    // نام جدول رو مشخص می‌کنیم (اسم دقیق از migration)
    protected $table = 'online_purchase_shopper_images';

    // فیلدهایی که قابل پر شدن هستن
    protected $fillable = [
        'purchase_shopper_id',
        'path',
    ];

    // غیرفعال کردن timestamps اگه توی جدول نداری
    // public $timestamps = false;

    // رابطه با خریدار
    public function shopper(): BelongsTo
    {
        return $this->belongsTo(OnlinePurchaseShopper::class, 'shopper_id');
    }
}
