<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Shipment extends Model
{
    protected $table = 'shipments';

    public $timestamps = true;

    protected $fillable = [
        'user_id',
        'type',
        'origin_country',
        'origin_city',
        'origin_address',
        'origin_coordinates',
        'destination_country',
        'destination_city',
        'destination_address',
        'destination_coordinates',
        'title',
        'weight',
        'carry_weight_capacity',
        'amount',
        'currency',
        'status',
        'description',
        'trip_description',
        'price_type',
        'show_phone',
        'departure_date',
        'arrival_date',
        'category',
        'rejection_reason' // ✅ اضافه شد
    ];

    protected $casts = [
        'show_phone' => 'boolean',
        'weight' => 'decimal:2',
        'carry_weight_capacity' => 'decimal:2',
        'amount' => 'decimal:2',
        'departure_date' => 'date',
        'arrival_date' => 'date',
    ];

    // رابطه با کاربر
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // رابطه با تصاویر
    public function images()
    {
        return $this->hasMany(ShipmentImage::class, 'shipment_id');
    }

    // Scopes
    public function scopeSend($query)
    {
        return $query->where('type', 'send');
    }

    public function scopeCarry($query)
    {
        return $query->where('type', 'carry');
    }

    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    public function scopeApproved($query)
    {
        return $query->where('status', 'approved');
    }

    public function scopeRejected($query)
    {
        return $query->where('status', 'rejected');
    }
}
