<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ShipmentImage extends Model
{
    protected $table = 'shipment_images';

    protected $fillable = ['shipment_id', 'image_path'];

    // اضافه کردن url به appends
    protected $appends = ['url'];

    public function shipment()
    {
        return $this->belongsTo(Shipment::class);
    }

    /**
     * تولید URL کامل تصویر
     */
    public function getUrlAttribute()
    {
        if (!$this->image_path) {
            return null;
        }

        // اگر مسیر کامل باشه
        if (str_starts_with($this->image_path, 'http')) {
            return $this->image_path;
        }

        // ساخت URL با asset()
        return asset($this->image_path);
    }
}
