<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\TicketReply; // مهم: این import را اضافه کنید
use App\Models\TicketAttachment; // مهم: این import را اضافه کنید

class Ticket extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'ticket_number',
        'title',
        'message',
        'status',
        'priority',
        'department',
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    protected $appends = ['replies_count', 'last_activity'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function replies()
    {
        return $this->hasMany(TicketReply::class);
    }

    public function attachments()
    {
        return $this->hasMany(TicketAttachment::class);
    }

    // Accessor برای تعداد پاسخ‌ها
    public function getRepliesCountAttribute()
    {
        // استفاده از loadCount برای بهینه‌سازی
        if (!$this->relationLoaded('replies')) {
            $this->loadCount('replies');
        }
        return $this->replies_count ?? $this->replies->count();
    }

    // Accessor برای آخرین فعالیت
    public function getLastActivityAttribute()
    {
        $lastReply = $this->replies()->latest()->first();
        return $lastReply ? $lastReply->created_at : $this->updated_at;
    }
}
