<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Trip extends Model
{
    protected $fillable = [
        'user_id', 'origin_country', 'origin_city', 'origin_address',
        'destination_country', 'destination_city', 'destination_address',
        'available_from', 'available_to', 'capacity', 'description',
        'show_phone', 'status', 'rejection_reason'
    ];

    protected $casts = [
        'available_from' => 'date',
        'available_to' => 'date',
        'status' => 'string',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}