<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('shipments', function (Blueprint $table) {
            // اضافه کردن ستون دلایل رد درخواست
            // از نوع text استفاده می‌کنیم چون ممکن است متن طولانی باشد
            // nullable() است چون این ستون همیشه پر نخواهد بود
            $table->text('rejection_reason')->nullable()->after('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('shipments', function (Blueprint $table) {
            // برای حالت rollback، ستون را حذف می‌کنیم
            $table->dropColumn('rejection_reason');
        });
    }
};