<?php

use App\Http\Controllers\Auth\AdminAuthController;
use App\Http\Controllers\Admin\AdminDashboardController;
use App\Http\Controllers\Admin\AdminShipmentController;
use App\Http\Controllers\Admin\AdminTripController;
use App\Http\Controllers\Admin\AdminTripCompanionController;
use App\Http\Controllers\Admin\AdminOnlinePurchaseController;
use App\Http\Controllers\Admin\AdminUserController;
use App\Http\Controllers\Admin\AdminAllRequestsController;
use App\Http\Controllers\Admin\AdminTicketController;
// ✅ اضافه کردن کنترلرهای مقاله
use App\Http\Controllers\Admin\ArticleController;
use App\Http\Controllers\Admin\ArticleCategoryController;

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Admin Authentication Routes
|--------------------------------------------------------------------------
*/
Route::get('/test-auth-header', function () {
    return [
        'auth' => request()->header('Authorization'),
        'x_auth' => request()->header('X-Auth-Token'),
        'all_headers' => request()->headers->all(),
    ];
});


Route::get('/ping', function () {
    $deployLog = base_path('deploy.log');
    $lastDeploy = 'No deploy yet';
    
    if (file_exists($deployLog)) {
        $logs = file($deployLog, FILE_IGNORE_NEW_LINES);
        $lastDeploy = end($logs);
    }
    
    return response()->json([
        'status' => 'pong',
        'version' => '1.1', // این رو هر بار عوض کن
        'timestamp' => now()->toDateTimeString(),
        'last_deploy_log' => $lastDeploy,
        'php_version' => PHP_VERSION,
        'laravel_version' => app()->version()
    ]);
});



Route::prefix('admin')->group(function () {
    Route::post('/auth/request-otp', [AdminAuthController::class, 'requestOtp']);
    Route::post('/auth/verify-otp', [AdminAuthController::class, 'verifyOtp']);

   
});


Route::prefix('admin')
    ->middleware([
        \App\Http\Middleware\AdminMiddleware::class,
        'auth:sanctum',
    ])
    ->group(function () {

        Route::get('/auth/check', function () {
            return response()->json([
                'valid' => true,
                'admin' => auth()->user(),
            ]);
        });

    });

/*
|--------------------------------------------------------------------------
| Admin Protected Routes (auth:sanctum)
|--------------------------------------------------------------------------
*/

Route::prefix('admin')->middleware('auth:sanctum')->group(function () {

    Route::get('/dashboard', [AdminDashboardController::class, 'index']);

    // مرسولات
    Route::get('/shipments', [AdminShipmentController::class, 'index']);
    Route::get('/shipments/{id}', [AdminShipmentController::class, 'show']);
    Route::put('/shipments/{id}/approve', [AdminShipmentController::class, 'approve']);
    Route::put('/shipments/{id}/reject', [AdminShipmentController::class, 'reject']);

    // سفر
    Route::get('/trips', [AdminTripController::class, 'index']);
    Route::get('/trips/{id}', [AdminTripController::class, 'show']);
    Route::put('/trips/{id}/approve', [AdminTripController::class, 'approve']);
    Route::put('/trips/{id}/reject', [AdminTripController::class, 'reject']);

    // همسفری
    Route::get('/trip-companions', [AdminTripCompanionController::class, 'index']);
    Route::get('/trip-companions/{id}', [AdminTripCompanionController::class, 'show']);
    Route::put('/trip-companions/{id}/approve', [AdminTripCompanionController::class, 'approve']);
    Route::put('/trip-companions/{id}/reject', [AdminTripCompanionController::class, 'reject']);

    // خریدهای اینترنتی
    Route::get('/online-purchases', [AdminOnlinePurchaseController::class, 'purchaseIndex']);
    Route::get('/online-purchases/{id}', [AdminOnlinePurchaseController::class, 'purchaseShow']);
    Route::put('/online-purchases/{id}/approve', [AdminOnlinePurchaseController::class, 'purchaseApprove']);
    Route::put('/online-purchases/{id}/reject', [AdminOnlinePurchaseController::class, 'purchaseReject']);

    // خریداران
    Route::get('/online-shoppers', [AdminOnlinePurchaseController::class, 'shopperIndex']);
    Route::get('/online-shoppers/{id}', [AdminOnlinePurchaseController::class, 'shopperShow']);
    Route::put('/online-shoppers/{id}/approve', [AdminOnlinePurchaseController::class, 'shopperApprove']);
    Route::put('/online-shoppers/{id}/reject', [AdminOnlinePurchaseController::class, 'shopperReject']);

    // کاربران
    Route::get('/users', [AdminUserController::class, 'index']);
    Route::post('/users/{id}/ban', [AdminUserController::class, 'ban']);
    Route::post('/users/{id}/unban', [AdminUserController::class, 'unban']);

    // تمام درخواست‌ها
    Route::get('/all-requests', [AdminAllRequestsController::class, 'index']);

    // تیکت‌ها
    Route::prefix('tickets')->group(function () {
        Route::get('/', [AdminTicketController::class, 'index']);
        Route::get('/stats', [AdminTicketController::class, 'stats']);
        Route::get('/{id}', [AdminTicketController::class, 'show']);
        Route::post('/{id}/reply', [AdminTicketController::class, 'reply']);
        Route::put('/{id}/status', [AdminTicketController::class, 'updateStatus']);
    });

    // ✅ مدیریت مقالات — بدون تغییر
    Route::apiResource('articles', ArticleController::class)->except(['create', 'edit']);
    Route::apiResource('article-categories', ArticleCategoryController::class)->except(['create', 'edit']);
});