import React from 'react';
import { PlaneIcon } from '../Icons';

const AnimatedBackground: React.FC = () => {
  // A complex flight path that includes loops and a heart shape.
  const flightPath = "M-100 400 C 100 200, 250 600, 450 400 C 550 300, 650 300, 650 400 C 650 500, 550 600, 450 500 C 350 400, 250 400, 250 500 C 250 600, 450 700, 650 500 C 850 300, 1150 300, 1350 500 L1500 500";
  const pathId = "flightPath";
  const maskId = "trailMask";

  return (
    <div className="absolute inset-0 z-0 overflow-hidden" aria-hidden="true">
      <svg
        width="100%"
        height="100%"
        viewBox="0 0 1400 800"
        preserveAspectRatio="xMidYMid slice"
        className="absolute inset-0 opacity-40 dark:opacity-70"
      >
        <defs>
          <path id={pathId} d={flightPath} fill="none" />
          <mask id={maskId}>
            {/* This path acts as the mask. It's a solid white line that gets "drawn" to reveal the dashed path below. */}
            <use 
              href={`#${pathId}`} 
              stroke="white" 
              strokeWidth="5" 
              className="animate-draw-trail" 
            />
          </mask>
        </defs>

        {/* The visible dashed trail, which is revealed by the animated mask. */}
        <use 
          href={`#${pathId}`} 
          stroke="currentColor" 
          strokeWidth="2" 
          strokeDasharray="8 12" 
          className="text-custom-purple"
          mask={`url(#${maskId})`}
        />
        
        {/* The plane icon that follows the path */}
        <g className="animate-fly-plane">
           <PlaneIcon 
              className="text-custom-purple" 
              width={50} 
              height={50} 
              style={{ transform: 'translate(-25px, -25px)' }}
           />
        </g>
      </svg>
    </div>
  );
};

export default AnimatedBackground;
