// src/components/pages/AllRequestsDetailPage.tsx
import React, { useEffect } from 'react';
import ShipmentDetailPage from './ShipmentDetailPage';
import TripDetailPage from './TripDetailPage';
import PurchaseDetailPage from './PurchaseDetailPage';
import AdminTicketDetailPage from './TicketDetailPage';

interface AllRequestsDetailPageProps {
    requestId: number | null;
    requestType: 'shipment' | 'trip' | 'purchase' | 'shopper' | 'ticket' | null;
    onNavigate: (page: string, payload?: any) => void;
    showError: (message: string) => void;
    showSuccess: (message: string) => void;
}

const AllRequestsDetailPage: React.FC<AllRequestsDetailPageProps> = ({
    requestId,
    requestType,
    onNavigate,
    showError,
    showSuccess
}) => {
    // بررسی معتبر بودن داده‌ها
    useEffect(() => {
        if (!requestId || !requestType) {
            // showError('اطلاعات درخواست نامعتبر است');
            onNavigate('all-requests');
        }
    }, [requestId, requestType]);

    if (!requestId || !requestType) {
        return null;
    }

    // هدایت به صفحه مناسب بر اساس نوع درخواست
    switch (requestType) {
        case 'shipment':
            return (
                <ShipmentDetailPage
                    shipmentId={requestId.toString()}
                    onNavigate={onNavigate}
                    isOwnerView={true}
                    showError={showError}
                    showSuccess={showSuccess}
                />
            );

        case 'trip':
            return (
                <TripDetailPage
                    tripId={requestId.toString()}
                    tripType="trip"
                    onNavigate={onNavigate}
                    showError={showError}
                    showSuccess={showSuccess}
                />
            );

        case 'purchase':
            return (
                <PurchaseDetailPage
                    purchaseId={requestId.toString()}
                    purchaseType="purchase"
                    onNavigate={onNavigate}
                    showError={showError}
                    showSuccess={showSuccess}
                />
            );

        case 'shopper':
            return (
                <PurchaseDetailPage
                    purchaseId={requestId.toString()}
                    purchaseType="shopper"
                    onNavigate={onNavigate}
                    showError={showError}
                    showSuccess={showSuccess}
                />
            );

        case 'ticket':
            return (
                <AdminTicketDetailPage
                    ticketId={requestId.toString()}
                    onNavigate={onNavigate}
                />
            );

        default:
            // showError('نوع درخواست نامعتبر است');
            onNavigate('all-requests');
            return null;
    }
};

export default AllRequestsDetailPage;
