// src/lib/api.ts
const API_BASE_URL = 'http://127.0.0.1:8000/api';

export const authFetch = async (url: string, options: RequestInit = {}) => {
  const token = localStorage.getItem('auth_token');

  if (!token) {
    localStorage.removeItem('auth_token');
    localStorage.removeItem('auth_phone');
    window.location.reload();
    throw new Error('Not authenticated');
  }

  const fullUrl = url.startsWith('http') ? url : `${API_BASE_URL}${url}`;

  const response = await fetch(fullUrl, {
    ...options,
    headers: {
      'Authorization': `Bearer ${token}`,
      'Content-Type': 'application/json',
      ...options.headers,
    },
  });

  if (response.status === 401) {
    localStorage.removeItem('auth_token');
    localStorage.removeItem('auth_phone');
    window.location.reload();
    throw new Error('Token expired or invalid');
  }

  if (!response.ok) {
    const data = await response.json().catch(() => ({}));
    throw new Error(data.error || 'خطا در انجام عملیات');
  }

  return response;
};