<?php
// app/Models/OnlinePurchaseRequest.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OnlinePurchaseRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'title',
        'link',
        'description',
        'delivery_lat',
        'delivery_lng',
        'delivery_country',
        'delivery_city',
        'delivery_address',
        'item_price',
        'proposed_fee',
        'currency',
        'show_phone',
        'status',
    ];

    protected $casts = [
        'delivery_lat' => 'decimal:8',
        'delivery_lng' => 'decimal:8',
        'item_price'   => 'decimal:2',
        'proposed_fee' => 'decimal:2',
        'show_phone'   => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function images()
    {
        return $this->hasMany(OnlinePurchaseImage::class, 'purchase_request_id');
    }
}
