<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Shipment extends Model
{
    use HasFactory;

    const TYPE_SEND = 'send';
    const TYPE_CARRY = 'carry';

    protected $fillable = [
        'user_id',
        'type',
        'origin_country',
        'origin_city',
        'origin_address',
        'origin_coordinates',
        'destination_country',
        'destination_city',
        'destination_address',
        'destination_coordinates',
        'title',
        'description',
        'weight',
        'category',
        'departure_date',
        'arrival_date',
        'carry_weight_capacity',
        'trip_description',
        'price_type',
        'currency',
        'amount',
        'show_phone',
        'status',
    ];

    protected $casts = [
        'show_phone' => 'boolean',
        'status' => 'string',
        'weight' => 'decimal:2',
        'carry_weight_capacity' => 'decimal:2',
        'amount' => 'decimal:2',
        'departure_date' => 'date',
        'arrival_date' => 'date',
    ];

    // Relations
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function images()
    {
        return $this->hasMany(ShipmentImage::class);
    }

    // Scopes
    public function scopeSend($query)
    {
        return $query->where('type', self::TYPE_SEND);
    }

    public function scopeCarry($query)
    {
        return $query->where('type', self::TYPE_CARRY);
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
