<?php
// app/Models/Ticket.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ticket extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'title',
        'message',
        'department',
        'priority',
        'status',
        'ticket_number'
    ];

    protected $casts = [
        'user_id' => 'integer',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function replies()
    {
        return $this->hasMany(TicketReply::class);
    }

    public function attachments()
    {
        return $this->hasMany(TicketAttachment::class);
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($ticket) {
            $ticket->ticket_number = 'TKT-' . date('Ymd') . '-' . str_pad(static::whereDate('created_at', today())->count() + 1, 4, '0', STR_PAD_LEFT);
        });
    }

    public function getDepartmentFaAttribute()
    {
        $departments = [
            'technical' => 'پشتیبانی فنی',
            'financial' => 'مالی',
            'suggestions' => 'پیشنهادات'
        ];

        return $departments[$this->department] ?? $this->department;
    }

    public function getPriorityFaAttribute()
    {
        $priorities = [
            'low' => 'کم',
            'medium' => 'متوسط',
            'high' => 'زیاد'
        ];

        return $priorities[$this->priority] ?? $this->priority;
    }

    public function getStatusFaAttribute()
    {
        $statuses = [
            'open' => 'باز',
            'in_progress' => 'در حال بررسی',
            'resolved' => 'حل شده',
            'closed' => 'بسته'
        ];

        return $statuses[$this->status] ?? $this->status;
    }
}
