<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TicketAttachment extends Model
{
    use HasFactory;

    protected $fillable = [
        'ticket_id',
        'ticket_reply_id',
        'file_path',
        'file_name',
        'file_size',
        'mime_type'
    ];

    protected $appends = ['url'];

    public function getUrlAttribute()
    {
        // تغییر از storage به مسیر عمومی
        return asset($this->file_path);
    }

    public function ticket()
    {
        return $this->belongsTo(Ticket::class);
    }

    public function reply()
    {
        return $this->belongsTo(TicketReply::class, 'ticket_reply_id');
    }
}
