<?php
// database/migrations/2024_01_01_000004_create_tickets_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('tickets', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('title'); // این فیلد اضافه شد
            $table->text('message');
            $table->enum('department', ['technical', 'financial', 'suggestions'])->default('technical');
            $table->enum('priority', ['low', 'medium', 'high'])->default('medium');
            $table->enum('status', ['open', 'in_progress', 'resolved', 'closed'])->default('open');
            $table->string('ticket_number')->unique();
            $table->timestamps();
            
            // ایندکس برای عملکرد بهتر
            $table->index(['user_id', 'status']);
            $table->index(['department', 'priority']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('tickets');
    }
};