import React from "react";

interface ConfirmDeleteModalProps {
    open: boolean;
    title?: string;
    message?: string;
    onCancel: () => void;
    onConfirm: () => void;
}

const ConfirmDeleteModal: React.FC<ConfirmDeleteModalProps> = ({
    open,
    title = "حذف آیتم",
    message = "آیا از حذف این مورد مطمئن هستید؟ این عملیات غیرقابل بازگشت است.",
    onCancel,
    onConfirm
}) => {
    if (!open) return null;

    return (
        <div className="fixed inset-0 z-50 bg-black/50 backdrop-blur-sm flex items-center justify-center p-4">

            <div className="bg-custom-light-card dark:bg-custom-dark-blue-light w-full max-w-md rounded-2xl shadow-xl p-6 animate-scale-in relative">

                <h3 className="text-xl font-bold text-gray-800 dark:text-white mb-4">{title}</h3>

                <p className="text-gray-600 dark:text-gray-300 leading-relaxed mb-6">
                    {message}
                </p>

                <div className="flex items-center justify-end gap-3">
                    <button
                        onClick={onCancel}
                        className="px-4 py-2 rounded-lg bg-gray-200 dark:bg-gray-700 text-gray-800 dark:text-gray-200"
                    >
                        انصراف
                    </button>

                    <button
                        onClick={onConfirm}
                        className="px-4 py-2 rounded-lg bg-red-600 hover:bg-red-700 text-white"
                    >
                        حذف کن
                    </button>
                </div>

            </div>
        </div>
    );
};

export default ConfirmDeleteModal;
