import React from 'react';
import { MoonIcon, SunIcon, BellIcon, MenuIcon } from './Icons';

interface HeaderProps {
    onMenuClick: () => void;
    theme: string;
    toggleTheme: () => void;
    onNavigate: (page: string) => void;
}

const Header: React.FC<HeaderProps> = ({ onMenuClick, theme, toggleTheme, onNavigate }) => {
    return (
        <header className="flex items-center justify-between p-4 sm:p-4 lg:p-4 bg-custom-light-card dark:bg-custom-dark-blue-light shadow-md dark:shadow-none sticky top-0 z-20">
            <div className="flex items-center">
                 <button onClick={onMenuClick} className="lg:hidden text-gray-500 dark:text-gray-400 mr-4" aria-label="Open menu">
                     <MenuIcon className="w-6 h-6" />
                </button>
            </div>

            <div className="flex items-center space-x-2 sm:space-x-4 space-x-reverse">
                <div className="flex items-center space-x-1 sm:space-x-3 space-x-reverse">
                    <button onClick={() => onNavigate('messages')} className="p-2 bg-custom-light-bg dark:bg-custom-dark-blue-light rounded-full cursor-pointer relative" aria-label="Messages">
                         <BellIcon className="h-6 w-6 text-gray-600 dark:text-gray-300"/>
                        <span className="absolute top-0 right-0 block h-2 w-2 rounded-full ring-2 ring-custom-light-card dark:ring-custom-dark-blue-light bg-custom-orange"></span>
                    </button>
                    <button onClick={toggleTheme} className="p-2 bg-custom-light-bg dark:bg-custom-dark-blue-light rounded-full cursor-pointer" aria-label="Toggle theme">
                         {theme === 'dark' ? (
                             <SunIcon className="h-6 w-6 text-yellow-400" />
                         ) : (
                             <MoonIcon className="h-6 w-6 text-gray-800" />
                         )}
                    </button>
                </div>
                <img src="https://picsum.photos/id/64/100/100" alt="User Avatar" className="w-12 h-12 rounded-full" />
            </div>
        </header>
    );
};

export default Header;