import React, { useState } from 'react';
import {
    DashboardIcon, PackageIcon, PlaneIcon, ChatIcon, TicketIcon, UserIcon, LogoutIcon, ChevronDownIcon, SuitcaseIcon, ECommerceIcon
} from './Icons';

interface SidebarProps {
    isOpen: boolean;
    currentPage: string;
    onNavigate: (page: string) => void;
}

const menuItems = [
    { name: 'داشبورد', icon: DashboardIcon, id: 'dashboard' },
    {
        name: 'مرسولات',
        icon: PackageIcon,
        id: 'shipments',
        children: [
            { name: 'ثبت مرسوله', id: 'register-shipment' },
           // { name: 'قبول کردن مرسوله', id: 'accept-shipment' },
            { name: 'لیست درخواست‌های من', id: 'my-shipment-requests' },
        ],
    },
    {
        name: 'سفر ها',
        icon: PlaneIcon,
        id: 'trips',
        children: [
            { name: 'ثبت سفر', id: 'register-trip' },
           // { name: 'قبول کردن همسفر', id: 'accept-companion' },
            { name: 'لیست سفرهای من', id: 'my-trips' },
        ],
    },
    {
        name: 'خرید اینترنتی',
        icon: ECommerceIcon,
        id: 'online-purchase',
        children: [
            { name: 'ثبت خرید اینترنتی', id: 'register-online-purchase' },
          //  { name: 'قبول کردن خرید اینترنتی', id: 'accept-online-purchase' },
            { name: 'لیست درخواست‌های من', id: 'my-purchase-requests' },
        ],
    },
    { name: 'پیام ها', icon: ChatIcon, id: 'messages' },
    {
        name: 'تیکت‌ها',
        icon: TicketIcon,
        id: 'tickets-parent',
        children: [
            { name: 'لیست تیکت‌ها', id: 'tickets' },
            { name: 'ارسال تیکت جدید', id: 'new-ticket' },
        ],
    },
    { name: 'حساب کاربری', icon: UserIcon, id: 'account' },
    { name: 'خروج', icon: LogoutIcon, id: 'logout' },
];


const Sidebar: React.FC<SidebarProps> = ({ isOpen, currentPage, onNavigate }) => {
    const [openMenu, setOpenMenu] = useState('');

    const handleParentClick = (id: string) => {
        setOpenMenu(prev => (prev === id ? '' : id));
    };

    const handleChildClick = (id: string) => {
        onNavigate(id);
    };

    return (
        <aside className={`bg-custom-light-card dark:bg-custom-dark-blue-light w-64 p-6 flex flex-col h-screen fixed lg:sticky top-0 right-0 z-40 transition-transform duration-300 ease-in-out ${isOpen ? 'translate-x-0' : 'translate-x-full'} lg:translate-x-0`}>
            <div className="flex items-center justify-between mb-10">
                <div className="flex items-center">
                    <SuitcaseIcon className="w-10 h-10 text-custom-purple" />
                    <span className="text-2xl font-bold text-gray-800 dark:text-white mr-2">اینوببر</span>
                </div>
            </div>

            <nav className="flex-grow">
                <ul>
                    {menuItems.map((item) => {
                        const isParentActive = item.children?.some(child => child.id === currentPage);
                        const isParentOpen = openMenu === item.id;

                        if (item.children) {
                            return (
                                <li key={item.id} className="my-1">
                                    <div
                                        className={`flex items-center justify-between p-3 cursor-pointer rounded-lg transition-colors ${isParentActive ? 'text-custom-purple' : 'hover:bg-gray-100 dark:hover:bg-custom-dark-blue'}`}
                                        onClick={() => handleParentClick(item.id)}
                                    >
                                        <div className="flex items-center">
                                            <item.icon className="w-5 h-5 ml-3" />
                                            <span className={`${isParentActive ? 'font-semibold' : ''}`}>{item.name}</span>
                                        </div>
                                        <ChevronDownIcon className={`w-5 h-5 transition-transform ${isParentOpen ? 'rotate-180' : ''}`} />
                                    </div>
                                    {isParentOpen && (
                                        <ul className="mr-6 mt-1 border-r-2 border-gray-200 dark:border-gray-600">
                                            {item.children.map((child) => {
                                                const isChildActive = currentPage === child.id;
                                                return (
                                                    <li
                                                        key={child.id}
                                                        className={`p-2 pr-4 my-1 cursor-pointer rounded-r-lg transition-colors relative ${isChildActive ? 'bg-custom-purple/10 text-custom-purple' : 'hover:bg-gray-100 dark:hover:bg-custom-dark-blue'}`}
                                                        onClick={() => handleChildClick(child.id)}
                                                    >
                                                        {isChildActive && <div className="absolute right-0 top-0 h-full w-1 bg-custom-purple rounded-r-full"></div>}
                                                        <span className={`${isChildActive ? 'font-bold' : ''}`}>{child.name}</span>
                                                    </li>
                                                );
                                            })}
                                        </ul>
                                    )}
                                </li>
                            );
                        }

                        const isActive = currentPage === item.id;
                        return (
                            <li
                                key={item.id}
                                className={`flex items-center p-3 my-1 cursor-pointer transition-colors ${isActive ? 'bg-custom-purple text-white rounded-lg' : 'rounded-lg hover:bg-gray-100 dark:hover:bg-custom-dark-blue'}`}
                                onClick={() => handleChildClick(item.id)}
                            >
                                <item.icon className="w-5 h-5 ml-3" />
                                <span className={`flex-grow ${isActive ? 'font-semibold' : ''}`}>{item.name}</span>
                            </li>
                        );
                    })}
                </ul>
            </nav>
        </aside>
    );
};

export default Sidebar;