<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class PhoneAuthController extends Controller
{
    public function requestOtp(Request $request)
    {
        $request->validate([
            'phone' => 'required|string|regex:/^09[0-9]{9}$/'
        ]);

        $phone = $request->phone;

        // 1. محدودیت: حداکثر 6 درخواست در 1 ساعت
        $hourlyKey = "otp_hourly_limit:{$phone}";
        $attempts = Cache::get($hourlyKey, 0);
        if ($attempts >= 6) {
            return response()->json([
                'error' => 'شما بیش از 6 بار در یک ساعت درخواست داده‌اید. لطفاً بعداً تلاش کنید.'
            ], 429);
        }

        // 2. اگر کد هنوز معتبر است (ارسال شده در 10 دقیقه گذشته)
        $otpKey = "otp:{$phone}";
        if (Cache::has($otpKey)) {
            return response()->json([
                'message' => 'کد قبلاً ارسال شده است.'
            ], 200);
        }

        // 3. تولید OTP جدید
        $otp = 111111 ;// rand(100000, 999999);

        // 4. ذخیره OTP (10 دقیقه = 600 ثانیه)
        Cache::put($otpKey, $otp, 600);

        // 5. افزایش شمارنده درخواست‌های ساعتی
        Cache::put($hourlyKey, $attempts + 1, 3600);

        // 🔔 برای تست: OTP رو در لاگ نشون بده
        \Log::info("OTP for {$phone}: {$otp}");

        // 💡 بعداً اینجا AmootSMS فراخوانی می‌شه

        return response()->json([
            'message' => 'کد تأیید با موفقیت ارسال شد.'
        ]);
    }

    public function verifyOtp(Request $request)
    {
        $request->validate([
            'phone' => 'required|string|regex:/^09[0-9]{9}$/',
            'otp'   => 'required|digits:6'
        ]);

        $phone = $request->phone;
        $otp = $request->otp;

        $storedOtp = Cache::get("otp:{$phone}");

        if (!$storedOtp || $storedOtp != $otp) {
            return response()->json([
                'error' => 'کد نامعتبر یا منقضی شده است.'
            ], 400);
        }

        // پیدا کردن یا ساخت کاربر
        $user = User::firstOrCreate(
            ['phone' => $phone],
            ['phone_verified_at' => now()]
        );

        // صدور توکن
        $token = $user->createToken('eino-api-token')->plainTextToken;

        // پاک کردن OTP از کش
        Cache::forget("otp:{$phone}");

        return response()->json([
            'message' => 'ورود موفقیت‌آمیز بود.',
            'token' => $token,
            'user' => $user
        ]);
    }
}