<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ConvertAuthHeader
{
    public function handle(Request $request, Closure $next): Response
    {
        // اگر X-Auth-Token وجود داره، تبدیلش کن به Authorization
        if ($token = $request->header('X-Auth-Token')) {
            $request->headers->set('Authorization', 'Bearer ' . $token);
        }

        return $next($request);
    }
}
