<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OnlinePurchaseImage extends Model
{
    use HasFactory;

    protected $fillable = [
        'purchase_request_id',
        'path',
    ];

    /**
     * ✅ اضافه کردن url به خروجی JSON
     */
    protected $appends = ['url'];

    /**
     * ✅ ساخت URL کامل تصویر
     */
    public function getUrlAttribute()
    {
        return asset($this->path);
    }

    public function request()
    {
        return $this->belongsTo(OnlinePurchaseRequest::class, 'purchase_request_id');
    }
}
