<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ShipmentImage extends Model
{
    protected $fillable = ['shipment_id', 'image_path'];

    protected $appends = ['url'];

    public function shipment()
    {
        return $this->belongsTo(Shipment::class);
    }

    // ✅ تولید URL با asset()
    public function getUrlAttribute()
    {
        return asset($this->image_path);
    }
}
