<?php
// app/Models/TripImage.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TripImage extends Model
{
    use HasFactory;

    protected $fillable = [
        'trip_id',
        'path',
        'type',
    ];

    protected $appends = ['url'];

    public function getUrlAttribute()
    {
        return asset('storage/' . $this->path);
    }

    public function trip()
    {
        return $this->belongsTo(Trip::class);
    }
}