<?php
// database/migrations/2024_01_01_000004_create_online_purchase_requests_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('online_purchase_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // اطلاعات کالا
            $table->string('title');
            $table->text('link')->nullable();
            $table->text('description')->nullable();

            // محل تحویل
            $table->decimal('delivery_lat', 10, 8)->nullable();
            $table->decimal('delivery_lng', 11, 8)->nullable();
            $table->string('delivery_country')->nullable();
            $table->string('delivery_city')->nullable();
            $table->text('delivery_address')->nullable();

            // قیمت‌گذاری
            $table->decimal('item_price', 10, 2);
            $table->decimal('proposed_fee', 10, 2);
            $table->enum('currency', ['IRT', 'USD', 'CAD', 'IQD'])->default('IRT');

            // اطلاعات تماس
            $table->boolean('show_phone')->default(false);

            // وضعیت
            $table->string('status')->default('pending');

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('online_purchase_requests');
    }
};
