<?php
// app/Models/OnlinePurchaseShopper.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OnlinePurchaseShopper extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'country',
        'city',
        'service_title',
        'categories',
        'supported_sites',
        'fee_description',
        'capabilities',
        'show_phone',
        'status',
    ];

    protected $casts = [
        'categories'      => 'array',
        'supported_sites' => 'array',
        'show_phone'      => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function images()
    {
        return $this->hasMany(OnlinePurchaseShopperImage::class, 'purchase_shopper_id');
    }
}
