<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OnlinePurchaseShopperImage extends Model
{
    use HasFactory;

    protected $fillable = [
        'purchase_shopper_id',
        'path',
    ];

    /**
     * ✅ اضافه کردن url به خروجی JSON
     */
    protected $appends = ['url'];

    /**
     * ✅ ساخت URL کامل تصویر
     */
    public function getUrlAttribute()
    {
        return asset($this->path);
    }

    public function shopper()
    {
        return $this->belongsTo(OnlinePurchaseShopper::class, 'purchase_shopper_id');
    }
}
