<?php
// app/Models/Trip.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Trip extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'origin_country',
        'origin_city',
        'origin_address',
        'origin_coordinates',
        'destination_country',
        'destination_city',
        'destination_address',
        'destination_coordinates',
        'vehicle_type',
        'departure_date',
        'arrival_date',
        'capacity',
        'description',
        'show_phone',
        'status',
    ];

    protected $casts = [
        // 'departure_date' => 'date',
        // 'arrival_date' => 'date',
        'show_phone' => 'boolean',
        'capacity' => 'decimal:2',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function images()
    {
        return $this->hasMany(TripImage::class);
    }
}