<?php
// app/Models/TripCompanion.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TripCompanion extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'origin_country',
        'origin_city',
        'origin_address',
        'origin_coordinates',
        'destination_country',
        'destination_city',
        'destination_address',
        'destination_coordinates',
        'vehicle_types',
        'available_from',
        'available_to',
        'capacity',
        'description',
        'show_phone',
        'status',
    ];

    protected $casts = [
        'vehicle_types' => 'array',
        // 'available_from' => 'date',
        // 'available_to' => 'date',
        'show_phone' => 'boolean',
        'capacity' => 'decimal:2',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}