<?php
// database/migrations/2024_01_01_000005_create_online_purchase_shoppers_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('online_purchase_shoppers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            
            // محل فعالیت
            $table->string('country');
            $table->string('city');
            
            // اطلاعات خدمات
            $table->string('service_title')->nullable();
            $table->json('categories')->nullable();
            $table->json('supported_sites')->nullable();
            $table->text('fee_description')->nullable();
            $table->text('capabilities')->nullable();
            
            // اطلاعات تماس
            $table->boolean('show_phone')->default(false);
            
            // وضعیت
            $table->string('status')->default('pending');
            
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('online_purchase_shoppers');
    }
};