<?php
// database/migrations/2024_01_01_000001_create_trips_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('trips', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            
            // مبدأ
            $table->string('origin_country');
            $table->string('origin_city');
            $table->text('origin_address')->nullable();
            $table->string('origin_coordinates')->nullable();
            
            // مقصد
            $table->string('destination_country');
            $table->string('destination_city');
            $table->text('destination_address')->nullable();
            $table->string('destination_coordinates')->nullable();
            
            // جزئیات سفر
            $table->string('vehicle_type');
            $table->date('departure_date');
            $table->date('arrival_date')->nullable();
            $table->decimal('capacity', 8, 2);
            $table->text('description')->nullable();
            $table->boolean('show_phone')->default(false);
            $table->string('status')->default('pending');
            
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('trips');
    }
};