<?php
// database/migrations/2024_01_01_000002_create_trip_companions_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('trip_companions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            
            // مسیر
            $table->string('origin_country');
            $table->string('origin_city');
            $table->text('origin_address')->nullable();
            $table->string('origin_coordinates')->nullable();
            
            $table->string('destination_country');
            $table->string('destination_city');
            $table->text('destination_address')->nullable();
            $table->string('destination_coordinates')->nullable();
            
            // جزئیات همسفری
            $table->json('vehicle_types');
            $table->date('available_from');
            $table->date('available_to')->nullable();
            $table->decimal('capacity', 8, 2);
            $table->text('description')->nullable();
            $table->boolean('show_phone')->default(false);
            $table->string('status')->default('pending');
            
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('trip_companions');
    }
};