<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // جدول اصلی shipments (ترکیبی send + carry)
        Schema::create('shipments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            
            // نوع: send یا carry
            $table->enum('type', ['send', 'carry'])->default('send');
            
            // مبدأ و مقصد (مشترک)
            $table->string('origin_country');
            $table->string('origin_city');
            $table->text('origin_address')->nullable();
            $table->string('origin_coordinates')->nullable();
            $table->string('destination_country');
            $table->string('destination_city');
            $table->text('destination_address')->nullable();
            $table->string('destination_coordinates')->nullable();
            
            // فیلدهای مخصوص send
            $table->string('title')->nullable();
            $table->text('description')->nullable();
            $table->decimal('weight', 10, 2)->nullable();
            $table->string('category')->nullable();
            
            // فیلدهای مخصوص carry
            $table->date('departure_date')->nullable();
            $table->date('arrival_date')->nullable();
            $table->decimal('carry_weight_capacity', 10, 2)->nullable();
            $table->text('trip_description')->nullable();
            
            // قیمت (مشترک)
            $table->enum('price_type', ['fixed', 'negotiable'])->default('negotiable');
            $table->enum('currency', ['IRT', 'USD', 'CAD', 'IQD'])->nullable();
            $table->decimal('amount', 15, 2)->nullable();
            
            // سایر فیلدها
            $table->boolean('show_phone')->default(false);
            $table->string('status')->default("pending");
            $table->timestamps();
            
            // ایندکس‌ها
            $table->index('type');
            $table->index('user_id');
            $table->index('status');
            $table->index(['origin_city', 'destination_city']);
        });

        // جدول تصاویر (فقط برای send)
        Schema::create('shipment_images', function (Blueprint $table) {
            $table->id();
            $table->foreignId('shipment_id')->constrained()->onDelete('cascade');
            $table->string('image_path');
            $table->timestamps();
            
            $table->index('shipment_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('shipment_images');
        Schema::dropIfExists('shipments');
    }
};
