<?php

use App\Http\Controllers\Api\OnlinePurchaseController;
use App\Http\Controllers\Api\ShipmentController;
use App\Http\Controllers\Api\TicketController;
use App\Http\Controllers\Api\TripController;
use App\Http\Controllers\Auth\PhoneAuthController;

// ✅ بررسی احراز هویت
Route::middleware('auth:sanctum')->get('/auth/check', function () {
    return response()->json(['valid' => true]);
});
Route::get('/debug-token', function (\Illuminate\Http\Request $request) {
    return response()->json([
        'authorization_header' => $request->header('Authorization'),
        'bearer_token' => $request->bearerToken(),
        'all_headers' => collect($request->headers->all())->map(fn($h) => $h[0] ?? null),
    ]);
});


Route::get('/ping', function () {
    $deployLog = base_path('deploy.log');
    $lastDeploy = 'No deploy yet';
    
    if (file_exists($deployLog)) {
        $logs = file($deployLog, FILE_IGNORE_NEW_LINES);
        $lastDeploy = end($logs);
    }
    
    return response()->json([
        'status' => 'pong',
        'version' => '1.0.12', // این رو هر بار عوض کن
        'timestamp' => now()->toDateTimeString(),
        'last_deploy_log' => $lastDeploy,
        'php_version' => PHP_VERSION,
        'laravel_version' => app()->version()
    ]);
});


// ✅ احراز هویت با OTP
Route::post('/auth/request-otp', [PhoneAuthController::class, 'requestOtp']);
Route::post('/auth/verify-otp', [PhoneAuthController::class, 'verifyOtp']);



// Routes تیکت‌ها (نیاز به احراز هویت)
Route::middleware('auth:sanctum')->group(function () {
    // تیکت‌ها
    Route::prefix('tickets')->group(function () {
        Route::post('/', [TicketController::class, 'store']);
        Route::get('/', [TicketController::class, 'index']);
        Route::get('/{id}', [TicketController::class, 'show']);
        Route::post('/{id}/reply', [TicketController::class, 'reply']);
        Route::put('/{id}/close', [TicketController::class, 'close']);
    });
});

// ✅ مسیرهای محافظت شده
Route::middleware('auth:sanctum')->group(function () {

    // 🛒 خرید آنلاین
    Route::prefix('online-purchase')->group(function () {
        // درخواست‌ها
        Route::post('/request', [OnlinePurchaseController::class, 'storeRequest']);
        Route::get('/requests', [OnlinePurchaseController::class, 'getRequests']);
        Route::get('/my-requests', [OnlinePurchaseController::class, 'getMyRequests']);
        Route::get('/request/{id}', [OnlinePurchaseController::class, 'getRequest']);
        Route::delete('/request/{id}', [OnlinePurchaseController::class, 'deleteRequest']);

        // خریداران
        Route::post('/shopper', [OnlinePurchaseController::class, 'storeShopper']);
        Route::get('/shoppers', [OnlinePurchaseController::class, 'getShoppers']);
        Route::get('/my-shopper', [OnlinePurchaseController::class, 'getMyShopper']);
        Route::get('/shopper/{id}', [OnlinePurchaseController::class, 'getShopper']);
        Route::delete('/shopper/{id}', [OnlinePurchaseController::class, 'deleteShopper']);
        Route::post('/shopper/deactivate', [OnlinePurchaseController::class, 'deactivateShopper']);
        Route::post('/shopper/activate', [OnlinePurchaseController::class, 'activateShopper']);

        Route::put('/request/{id}', [OnlinePurchaseController::class, 'updateRequest']);
        Route::put('/shopper/{id}', [OnlinePurchaseController::class, 'updateShopper']);
    });

    // ✈️ سفرها
    Route::prefix('trips')->group(function () {
        Route::post('/register', [TripController::class, 'registerTrip']);
        Route::post('/companion', [TripController::class, 'registerCompanion']);
        Route::get('/my-trips', [TripController::class, 'getMyTrips']);
        Route::get('/my-companions', [TripController::class, 'getMyCompanions']);
        Route::get('/all-trips', [TripController::class, 'getTrips']);
        Route::get('/all-companions', [TripController::class, 'getCompanions']);

        Route::get('/trip/{id}', [TripController::class, 'getTrip']);
        Route::get('/companion/{id}', [TripController::class, 'getCompanion']);

        Route::delete('/trip/{id}', [TripController::class, 'deleteTrip']);
        Route::delete('/companion/{id}', [TripController::class, 'deleteCompanion']);

        Route::put('/trip/{id}', [TripController::class, 'updateTrip']);
        Route::put('/companion/{id}', [TripController::class, 'updateCompanion']);
    });

    // 📦 محموله‌ها
    Route::prefix('shipments')->group(function () {
        Route::post('/register', [ShipmentController::class, 'registerShipment']);
        Route::post('/carry', [ShipmentController::class, 'registerCarryTrip']);
        Route::get('/my-list', [ShipmentController::class, 'myShipments']);
        Route::delete('/{id}', [ShipmentController::class, 'destroy']);
        Route::get('/{id}', [ShipmentController::class, 'show']);
        Route::put('/{id}', [ShipmentController::class, 'update']);
        Route::delete('/{shipmentId}/images/{imageId}', [ShipmentController::class, 'deleteImage']);

    });

});
